/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.LogWriter;

public abstract class CommandNoppesBase
extends CommandBase {
    public Map<String, Method> subcommands = new HashMap<String, Method>();

    public CommandNoppesBase() {
        for (Method m : ((Object)((Object)this)).getClass().getDeclaredMethods()) {
            SubCommand sc = m.getAnnotation(SubCommand.class);
            if (sc == null) continue;
            String name = sc.name();
            if (name.isEmpty()) {
                name = m.getName().toLowerCase();
            }
            this.subcommands.put(name, m);
        }
    }

    public void canRun(MinecraftServer server, ICommandSender sender, String usage, String[] args) throws CommandException {
        String[] np = usage.split(" ");
        ArrayList<String> required = new ArrayList<String>();
        for (int i = 0; i < np.length; ++i) {
            String command = np[i];
            if (command.startsWith("<")) {
                required.add(command);
            }
            if (!command.equals("<player>") || args.length <= i) continue;
            CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[i]);
        }
        if (args.length < required.size()) {
            throw new CommandException("Missing parameter: " + (String)required.get(args.length), new Object[0]);
        }
    }

    public void func_184881_a(@Nullable MinecraftServer server, @Nullable ICommandSender sender, @Nullable String[] args) throws CommandException {
    }

    public void executeSub(MinecraftServer server, ICommandSender sender, String command, String[] args) throws CommandException {
        Method m = this.subcommands.get(command.toLowerCase());
        if (m == null) {
            throw new CommandException("Unknown subcommand " + command, new Object[0]);
        }
        SubCommand sc = m.getAnnotation(SubCommand.class);
        if (sc.permission() > this.getPermissionLevel(server, sender)) {
            throw new CommandException("You are not allowed to use \"" + Objects.requireNonNull(this.func_71517_b()).toLowerCase() + "." + command.toLowerCase() + "\" command", new Object[0]);
        }
        this.canRun(server, sender, sc.usage(), args);
        try {
            m.invoke((Object)this, server, sender, args);
        }
        catch (Exception e) {
            if (e.getCause() instanceof CommandException) {
                throw (CommandException)e.getCause();
            }
            LogWriter.error(e);
        }
    }

    public abstract String getDescription();

    @Nonnull
    public abstract String func_71517_b();

    public int func_82362_a() {
        return 0;
    }

    public String getUsage() {
        return "";
    }

    @Nonnull
    public String func_71518_a(@Nullable ICommandSender sender) {
        return this.getDescription();
    }

    public boolean runSubCommands() {
        return !this.subcommands.isEmpty();
    }

    protected void sendMessage(ICommandSender sender, String message, Object ... obs) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(message, obs));
    }

    public boolean func_184882_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender) {
        int thisPer = this.func_82362_a();
        if (sender instanceof EntityPlayerMP) {
            return thisPer <= this.getPermissionLevel(server, sender);
        }
        return sender.func_70003_b(thisPer, this.func_71517_b());
    }

    protected int getPermissionLevel(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender) {
        int per = 4;
        if (sender instanceof EntityPlayerMP) {
            per = 0;
            UserListOpsEntry util = (UserListOpsEntry)server.func_184103_al().func_152603_m().func_152683_b((Object)((EntityPlayerMP)sender).func_146103_bH());
            if (util != null) {
                per = util.func_152644_a();
            }
            if (((EntityPlayerMP)sender).func_184812_l_()) {
                per = Math.max(server.func_71264_H() ? 4 : 2, per);
            }
        }
        return per;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface SubCommand {
        public String desc();

        public String name() default "";

        public int permission() default 0;

        public String usage() default "";
    }
}

